/*
 *  PXIAbstractFramework.h
 *  Mixer
 *
 *  Created by decaf on 2/14/05.
 *  Copyright 2005 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef _____PXIABSTRACTFRAMEWORK_____
#define _____PXIABSTRACTFRAMEWORK_____

#include <string>
#include <vector>
#include "variant.h"
#include "stringmaniplib.h"
using namespace std;

class PXIAbstractFramework
{
public:
	PXIAbstractFramework( void );
	void	createNewWindow( const string & );
	string  ask ( const string &, const string & );
	string  answer ( const string &, const string &, const string &, const string & );
	
	int		getCurrentTool ( void );
	void	setCurrentTool ( int );
	
	/* Global Variables */
	
void		setGlobalVariable( int, const variant & );
variant		getGlobalVariable( int );
bool		hasGlobalVariable( const string & );
int			getGlobalVariableIndex( const string & );
	
	/* Object Management */
long long   getObjectIndex ( string );
bool		objectHasKey ( long long, string );
bool		objectHasIndex ( long long, long long );
long long	registerNewObject ( const variant & );
void		duplicateObject ( long long, long long );


	
private:
	map< string, int >	PXIGlobalVariableIndices;
	vector< variant >	PXIGlobalVariableTable;
	
	map < string, long long > PXIObjectIndices;
	vector < map < string, int > > PXIDataMemberIndices;
	vector < vector < variant > > PXIDataMemberTables;
	
	long long objectCounter;
};

#endif